
-- Funktion ruft von der EZB-API die aktuellen Wechselkurse ab und aktualisiert die vorhandenen Kurse
CREATE OR REPLACE FUNCTION x_10_interfaces.exchange_rates_update(_start_date date DEFAULT (CURRENT_DATE - 7), _end_date date DEFAULT CURRENT_DATE)
    RETURNS void
    LANGUAGE plpgsql
  AS $$
  DECLARE
    _url     varchar;
    _content jsonb;
  BEGIN

    -- URL für den EZB-API Abruf bauen
    _url := concat('https://data-api.ecb.europa.eu/service/data/EXR/D..',
                   TSystem.Settings__GetText('BASIS_W'),
                   '.SP00.A?',
                   'startPeriod=', TO_CHAR(_start_date, 'YYYY-MM-DD'),
                   '&endPeriod=',  TO_CHAR(_end_date,   'YYYY-MM-DD'),
                   '&lastNObservations=1&format=jsondata');

    -- HTTP-GET-Anfrage, um den XML-Content abzurufen
    -- gesonderter Block für exception handling
    BEGIN
        SELECT content::jsonb
        INTO _content
        FROM tsystem.http_get_request(_url);

    EXCEPTION
      WHEN OTHERS THEN
        RAISE WARNING 'x_10_interfaces.exchange_rates_update ERROR, missing implementation error handling';
    END;

    -- Überprüfen, ob die Anfrage erfolgreich war
    IF _content IS NOT NULL THEN

      --Kurse in Prodat aktualisieren
      UPDATE bewa
         SET wa_kurs = 1 / ezb_kurse.rate,
             wa_dat  = _end_date
        FROM (SELECT jsonb_path_query(_content, '$.structure.dimensions.series[*] ? (@.id == "CURRENCY") .values.id')   #>> '{}' AS currency,  -- Währungskürzel
                    (jsonb_path_query(_content, '$.dataSets[0].series.*.observations."0"[0]') #>> '{}')::numeric                 AS rate       -- "Kurs"
             ) AS ezb_kurse
       WHERE ezb_kurse.currency = wa_einh;

    END IF;

  END $$
  --
